
################################################################
# This is a generated script based on design: top
#
# Though there are limitations about the generated script,
# the main purpose of this utility is to make learning
# IP Integrator Tcl commands easier.
################################################################

namespace eval _tcl {
proc get_script_folder {} {
   set script_path [file normalize [info script]]
   set script_folder [file dirname $script_path]
   return $script_folder
}
}
variable script_folder
set script_folder [_tcl::get_script_folder]

################################################################
# Check if script is running in correct Vivado version.
################################################################
set scripts_vivado_version 2017.1
set current_vivado_version [version -short]

if { [string first $scripts_vivado_version $current_vivado_version] == -1 } {
   puts ""
   catch {common::send_msg_id "BD_TCL-109" "ERROR" "This script was generated using Vivado <$scripts_vivado_version> and is being run in <$current_vivado_version> of Vivado. Please run the script in Vivado <$scripts_vivado_version> then open the design in Vivado <$current_vivado_version>. Upgrade the design by running \"Tools => Report => Report IP Status...\", then run write_bd_tcl to create an updated script."}

   return 1
}

################################################################
# START
################################################################

# To test this script, run the following commands from Vivado Tcl console:
# source top_script.tcl

# If there is no project opened, this script will create a
# project, but make sure you do not have an existing project
# <./myproj/project_1.xpr> in the current working folder.

set list_projs [get_projects -quiet]
if { $list_projs eq "" } {
   create_project project_1 myproj -part xc7vx690tffg1761-3
}


# CHANGE DESIGN NAME HERE
set design_name top

# If you do not already have an existing IP Integrator design open,
# you can create a design using the following command:
#    create_bd_design $design_name

# Creating design if needed
set errMsg ""
set nRet 0

set cur_design [current_bd_design -quiet]
set list_cells [get_bd_cells -quiet]

if { ${design_name} eq "" } {
   # USE CASES:
   #    1) Design_name not set

   set errMsg "Please set the variable <design_name> to a non-empty value."
   set nRet 1

} elseif { ${cur_design} ne "" && ${list_cells} eq "" } {
   # USE CASES:
   #    2): Current design opened AND is empty AND names same.
   #    3): Current design opened AND is empty AND names diff; design_name NOT in project.
   #    4): Current design opened AND is empty AND names diff; design_name exists in project.

   if { $cur_design ne $design_name } {
      common::send_msg_id "BD_TCL-001" "INFO" "Changing value of <design_name> from <$design_name> to <$cur_design> since current design is empty."
      set design_name [get_property NAME $cur_design]
   }
   common::send_msg_id "BD_TCL-002" "INFO" "Constructing design in IPI design <$cur_design>..."

} elseif { ${cur_design} ne "" && $list_cells ne "" && $cur_design eq $design_name } {
   # USE CASES:
   #    5) Current design opened AND has components AND same names.

   set errMsg "Design <$design_name> already exists in your project, please set the variable <design_name> to another value."
   set nRet 1
} elseif { [get_files -quiet ${design_name}.bd] ne "" } {
   # USE CASES: 
   #    6) Current opened design, has components, but diff names, design_name exists in project.
   #    7) No opened design, design_name exists in project.

   set errMsg "Design <$design_name> already exists in your project, please set the variable <design_name> to another value."
   set nRet 2

} else {
   # USE CASES:
   #    8) No opened design, design_name not in project.
   #    9) Current opened design, has components, but diff names, design_name not in project.

   common::send_msg_id "BD_TCL-003" "INFO" "Currently there is no design <$design_name> in project, so creating one..."

   create_bd_design $design_name

   common::send_msg_id "BD_TCL-004" "INFO" "Making design <$design_name> as current_bd_design."
   current_bd_design $design_name

}

common::send_msg_id "BD_TCL-005" "INFO" "Currently the variable <design_name> is equal to \"$design_name\"."

if { $nRet != 0 } {
   catch {common::send_msg_id "BD_TCL-114" "ERROR" $errMsg}
   return $nRet
}

##################################################################
# DESIGN PROCs
##################################################################


# Hierarchical cell: mb0_lmb
proc create_hier_cell_mb0_lmb { parentCell nameHier } {

  variable script_folder

  if { $parentCell eq "" || $nameHier eq "" } {
     catch {common::send_msg_id "BD_TCL-102" "ERROR" "create_hier_cell_mb0_lmb() - Empty argument(s)!"}
     return
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_msg_id "BD_TCL-100" "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_msg_id "BD_TCL-101" "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj

  # Create cell and set as current instance
  set hier_obj [create_bd_cell -type hier $nameHier]
  current_bd_instance $hier_obj

  # Create interface pins
  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:lmb_rtl:1.0 dlmb
  create_bd_intf_pin -mode Slave -vlnv xilinx.com:interface:lmb_rtl:1.0 ilmb

  # Create pins
  create_bd_pin -dir I -from 0 -to 0 clk
  create_bd_pin -dir I -from 0 -to 0 rst

  # Create instance: mb0_dlmb_bram_ctrl, and set properties
  set mb0_dlmb_bram_ctrl [ create_bd_cell -type ip -vlnv xilinx.com:ip:lmb_bram_if_cntlr:4.0 mb0_dlmb_bram_ctrl ]

  # Create instance: mb0_ilmb_bram_ctrl, and set properties
  set mb0_ilmb_bram_ctrl [ create_bd_cell -type ip -vlnv xilinx.com:ip:lmb_bram_if_cntlr:4.0 mb0_ilmb_bram_ctrl ]

  # Create instance: mb0_lmb_bram, and set properties
  set mb0_lmb_bram [ create_bd_cell -type ip -vlnv xilinx.com:ip:blk_mem_gen:8.3 mb0_lmb_bram ]
  set_property -dict [ list \
CONFIG.Enable_B {Use_ENB_Pin} \
CONFIG.Memory_Type {True_Dual_Port_RAM} \
CONFIG.Port_B_Clock {100} \
CONFIG.Port_B_Enable_Rate {100} \
CONFIG.Port_B_Write_Rate {50} \
CONFIG.Use_RSTB_Pin {true} \
 ] $mb0_lmb_bram

  # Create interface connections
  connect_bd_intf_net -intf_net dlmb_1 [get_bd_intf_pins dlmb] [get_bd_intf_pins mb0_dlmb_bram_ctrl/SLMB]
  connect_bd_intf_net -intf_net ilmb_1 [get_bd_intf_pins ilmb] [get_bd_intf_pins mb0_ilmb_bram_ctrl/SLMB]
  connect_bd_intf_net -intf_net mb0_dlmb_bram_ctrl_BRAM_PORT [get_bd_intf_pins mb0_dlmb_bram_ctrl/BRAM_PORT] [get_bd_intf_pins mb0_lmb_bram/BRAM_PORTA]
  connect_bd_intf_net -intf_net mb0_ilmb_bram_ctrl_BRAM_PORT [get_bd_intf_pins mb0_ilmb_bram_ctrl/BRAM_PORT] [get_bd_intf_pins mb0_lmb_bram/BRAM_PORTB]

  # Create port connections
  connect_bd_net -net Net [get_bd_pins clk] [get_bd_pins mb0_dlmb_bram_ctrl/LMB_Clk] [get_bd_pins mb0_ilmb_bram_ctrl/LMB_Clk]
  connect_bd_net -net Net1 [get_bd_pins rst] [get_bd_pins mb0_dlmb_bram_ctrl/LMB_Rst] [get_bd_pins mb0_ilmb_bram_ctrl/LMB_Rst]

  # Restore current instance
  current_bd_instance $oldCurInst
}


# Procedure to create entire design; Provide argument to make
# procedure reusable. If parentCell is "", will use root.
proc create_root_design { parentCell } {

  variable script_folder

  if { $parentCell eq "" } {
     set parentCell [get_bd_cells /]
  }

  # Get object for parentCell
  set parentObj [get_bd_cells $parentCell]
  if { $parentObj == "" } {
     catch {common::send_msg_id "BD_TCL-100" "ERROR" "Unable to find parent cell <$parentCell>!"}
     return
  }

  # Make sure parentObj is hier blk
  set parentType [get_property TYPE $parentObj]
  if { $parentType ne "hier" } {
     catch {common::send_msg_id "BD_TCL-101" "ERROR" "Parent <$parentObj> has TYPE = <$parentType>. Expected to be <hier>."}
     return
  }

  # Save current instance; Restore later
  set oldCurInst [current_bd_instance .]

  # Set parent object as current
  current_bd_instance $parentObj


  # Create interface ports

  # Create ports
  set FPGA_SYSCLK_N [ create_bd_port -dir I -type clk FPGA_SYSCLK_N ]
  set_property -dict [ list \
CONFIG.FREQ_HZ {200000000} \
 ] $FPGA_SYSCLK_N
  set FPGA_SYSCLK_P [ create_bd_port -dir I -type clk FPGA_SYSCLK_P ]
  set_property -dict [ list \
CONFIG.FREQ_HZ {200000000} \
 ] $FPGA_SYSCLK_P
  set PCIE_CLK_N [ create_bd_port -dir I -from 0 -to 0 -type clk PCIE_CLK_N ]
  set_property -dict [ list \
CONFIG.FREQ_HZ {100000000} \
 ] $PCIE_CLK_N
  set PCIE_CLK_P [ create_bd_port -dir I -from 0 -to 0 -type clk PCIE_CLK_P ]
  set_property -dict [ list \
CONFIG.FREQ_HZ {100000000} \
 ] $PCIE_CLK_P
  set PCIE_RX_N [ create_bd_port -dir I -from 7 -to 0 PCIE_RX_N ]
  set PCIE_RX_P [ create_bd_port -dir I -from 7 -to 0 PCIE_RX_P ]
  set PCIE_TX_N [ create_bd_port -dir O -from 7 -to 0 PCIE_TX_N ]
  set PCIE_TX_P [ create_bd_port -dir O -from 7 -to 0 PCIE_TX_P ]
  set PERSTN [ create_bd_port -dir I -type rst PERSTN ]
  set RESET [ create_bd_port -dir I -type rst RESET ]
  set_property -dict [ list \
CONFIG.POLARITY {ACTIVE_HIGH} \
 ] $RESET
  set UART_RXD_OUT [ create_bd_port -dir O UART_RXD_OUT ]
  set UART_TXD_IN [ create_bd_port -dir I UART_TXD_IN ]

  # Create instance: QEMUPCIeBridge_0, and set properties
  set QEMUPCIeBridge_0 [ create_bd_cell -type ip -vlnv COMPAS:COMPAS:QEMUPCIeBridge:1.0.0 QEMUPCIeBridge_0 ]
  set_property -dict [ list \
CONFIG.ADRW {64} \
 ] $QEMUPCIeBridge_0

  # Create instance: axi_bram_ctrl_0, and set properties
  set axi_bram_ctrl_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_bram_ctrl:4.0 axi_bram_ctrl_0 ]
  set_property -dict [ list \
CONFIG.SINGLE_PORT_BRAM {1} \
 ] $axi_bram_ctrl_0

  # Create instance: axi_crossbar_dma_mm2s, and set properties
  set axi_crossbar_dma_mm2s [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_crossbar:2.1 axi_crossbar_dma_mm2s ]
  set_property -dict [ list \
CONFIG.M00_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A00_ADDR_WIDTH {0} \
CONFIG.M02_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A00_ADDR_WIDTH {0} \
CONFIG.M03_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A00_ADDR_WIDTH {0} \
CONFIG.M04_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A00_ADDR_WIDTH {0} \
CONFIG.M05_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A00_ADDR_WIDTH {0} \
CONFIG.M06_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A00_ADDR_WIDTH {0} \
CONFIG.M07_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A00_ADDR_WIDTH {0} \
CONFIG.M08_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A00_ADDR_WIDTH {0} \
CONFIG.M09_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A00_ADDR_WIDTH {0} \
CONFIG.M10_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A00_ADDR_WIDTH {0} \
CONFIG.M11_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A00_ADDR_WIDTH {0} \
CONFIG.M12_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A00_ADDR_WIDTH {0} \
CONFIG.M13_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A00_ADDR_WIDTH {0} \
CONFIG.M14_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A00_ADDR_WIDTH {0} \
CONFIG.M15_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A15_BASE_ADDR {0xffffffffffffffff} \
 ] $axi_crossbar_dma_mm2s

  # Create instance: axi_crossbar_dma_s2mm, and set properties
  set axi_crossbar_dma_s2mm [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_crossbar:2.1 axi_crossbar_dma_s2mm ]
  set_property -dict [ list \
CONFIG.M00_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A00_ADDR_WIDTH {0} \
CONFIG.M02_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A00_ADDR_WIDTH {0} \
CONFIG.M03_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A00_ADDR_WIDTH {0} \
CONFIG.M04_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A00_ADDR_WIDTH {0} \
CONFIG.M05_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A00_ADDR_WIDTH {0} \
CONFIG.M06_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A00_ADDR_WIDTH {0} \
CONFIG.M07_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A00_ADDR_WIDTH {0} \
CONFIG.M08_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A00_ADDR_WIDTH {0} \
CONFIG.M09_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A00_ADDR_WIDTH {0} \
CONFIG.M10_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A00_ADDR_WIDTH {0} \
CONFIG.M11_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A00_ADDR_WIDTH {0} \
CONFIG.M12_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A00_ADDR_WIDTH {0} \
CONFIG.M13_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A00_ADDR_WIDTH {0} \
CONFIG.M14_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A00_ADDR_WIDTH {0} \
CONFIG.M15_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A15_BASE_ADDR {0xffffffffffffffff} \
 ] $axi_crossbar_dma_s2mm

  # Create instance: axi_crossbar_pcie_s, and set properties
  set axi_crossbar_pcie_s [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_crossbar:2.1 axi_crossbar_pcie_s ]
  set_property -dict [ list \
CONFIG.ADDR_WIDTH {32} \
CONFIG.DATA_WIDTH {256} \
CONFIG.M00_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M00_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M01_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A00_ADDR_WIDTH {0} \
CONFIG.M02_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M02_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A00_ADDR_WIDTH {0} \
CONFIG.M03_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M03_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A00_ADDR_WIDTH {0} \
CONFIG.M04_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M04_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A00_ADDR_WIDTH {0} \
CONFIG.M05_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M05_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A00_ADDR_WIDTH {0} \
CONFIG.M06_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M06_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A00_ADDR_WIDTH {0} \
CONFIG.M07_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M07_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A00_ADDR_WIDTH {0} \
CONFIG.M08_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M08_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A00_ADDR_WIDTH {0} \
CONFIG.M09_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M09_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A00_ADDR_WIDTH {0} \
CONFIG.M10_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M10_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A00_ADDR_WIDTH {0} \
CONFIG.M11_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M11_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A00_ADDR_WIDTH {0} \
CONFIG.M12_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M12_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A00_ADDR_WIDTH {0} \
CONFIG.M13_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M13_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A00_ADDR_WIDTH {0} \
CONFIG.M14_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M14_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A00_ADDR_WIDTH {0} \
CONFIG.M15_A00_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A01_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A02_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A03_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A04_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A05_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A06_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A07_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A08_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A09_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A10_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A11_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A12_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A13_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A14_BASE_ADDR {0xffffffffffffffff} \
CONFIG.M15_A15_BASE_ADDR {0xffffffffffffffff} \
CONFIG.NUM_MI {1} \
CONFIG.NUM_SI {3} \
 ] $axi_crossbar_pcie_s

  # Create instance: axi_dma_0, and set properties
  set axi_dma_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_dma:7.1 axi_dma_0 ]
  set_property -dict [ list \
CONFIG.c_include_mm2s {1} \
CONFIG.c_include_sg {0} \
CONFIG.c_m_axi_mm2s_data_width {256} \
CONFIG.c_m_axi_s2mm_data_width {256} \
CONFIG.c_m_axis_mm2s_tdata_width {128} \
CONFIG.c_micro_dma {0} \
CONFIG.c_mm2s_burst_size {128} \
CONFIG.c_s2mm_burst_size {128} \
CONFIG.c_sg_include_stscntrl_strm {0} \
 ] $axi_dma_0

  # Create instance: axi_dwidth_converter_0, and set properties
  set axi_dwidth_converter_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_dwidth_converter:2.1 axi_dwidth_converter_0 ]
  set_property -dict [ list \
CONFIG.ADDR_WIDTH {32} \
CONFIG.MI_DATA_WIDTH {256} \
CONFIG.SI_DATA_WIDTH {32} \
 ] $axi_dwidth_converter_0

  # Create instance: axi_interconnect_mem, and set properties
  set axi_interconnect_mem [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_interconnect:2.1 axi_interconnect_mem ]
  set_property -dict [ list \
CONFIG.ENABLE_ADVANCED_OPTIONS {1} \
CONFIG.NUM_MI {1} \
CONFIG.NUM_SI {5} \
CONFIG.S00_HAS_DATA_FIFO {2} \
CONFIG.S01_HAS_DATA_FIFO {2} \
CONFIG.S02_HAS_DATA_FIFO {2} \
CONFIG.S03_HAS_DATA_FIFO {2} \
CONFIG.S04_HAS_DATA_FIFO {2} \
CONFIG.STRATEGY {2} \
 ] $axi_interconnect_mem

  # Create instance: axi_uartlite_0, and set properties
  set axi_uartlite_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_uartlite:2.0 axi_uartlite_0 ]
  set_property -dict [ list \
CONFIG.C_S_AXI_ACLK_FREQ_HZ {250000000} \
 ] $axi_uartlite_0

  # Create instance: axixbar_peripheral, and set properties
  set axixbar_peripheral [ create_bd_cell -type ip -vlnv xilinx.com:ip:axi_interconnect:2.1 axixbar_peripheral ]
  set_property -dict [ list \
CONFIG.ENABLE_ADVANCED_OPTIONS {1} \
CONFIG.NUM_MI {6} \
CONFIG.NUM_SI {3} \
CONFIG.S00_HAS_DATA_FIFO {2} \
CONFIG.S01_HAS_DATA_FIFO {2} \
CONFIG.S02_HAS_DATA_FIFO {2} \
CONFIG.STRATEGY {1} \
 ] $axixbar_peripheral

  # Create instance: blk_mem_gen_0, and set properties
  set blk_mem_gen_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:blk_mem_gen:8.3 blk_mem_gen_0 ]

  # Create instance: buf_pcieaxi_refclk, and set properties
  set buf_pcieaxi_refclk [ create_bd_cell -type ip -vlnv xilinx.com:ip:util_ds_buf:2.1 buf_pcieaxi_refclk ]
  set_property -dict [ list \
CONFIG.C_BUF_TYPE {IBUFDSGTE} \
 ] $buf_pcieaxi_refclk

  # Create instance: clk_wiz_0, and set properties
  set clk_wiz_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:clk_wiz:5.4 clk_wiz_0 ]
  set_property -dict [ list \
CONFIG.CLKIN1_JITTER_PS {50.0} \
CONFIG.CLKOUT1_DRIVES {BUFGCE} \
CONFIG.CLKOUT1_JITTER {93.990} \
CONFIG.CLKOUT1_PHASE_ERROR {89.971} \
CONFIG.CLKOUT1_REQUESTED_OUT_FREQ {250.000} \
CONFIG.CLKOUT2_DRIVES {BUFGCE} \
CONFIG.CLKOUT3_DRIVES {BUFGCE} \
CONFIG.CLKOUT4_DRIVES {BUFGCE} \
CONFIG.CLKOUT5_DRIVES {BUFGCE} \
CONFIG.CLKOUT6_DRIVES {BUFGCE} \
CONFIG.CLKOUT7_DRIVES {BUFGCE} \
CONFIG.FEEDBACK_SOURCE {FDBK_AUTO} \
CONFIG.MMCM_CLKFBOUT_MULT_F {5} \
CONFIG.MMCM_CLKIN1_PERIOD {5.000} \
CONFIG.MMCM_CLKIN2_PERIOD {10.0} \
CONFIG.MMCM_CLKOUT0_DIVIDE_F {4} \
CONFIG.MMCM_COMPENSATION {ZHOLD} \
CONFIG.MMCM_DIVCLK_DIVIDE {1} \
CONFIG.PRIMITIVE {PLL} \
CONFIG.PRIM_IN_FREQ {200.000} \
CONFIG.PRIM_SOURCE {Differential_clock_capable_pin} \
CONFIG.USE_SAFE_CLOCK_STARTUP {true} \
 ] $clk_wiz_0

  # Create instance: cpuclk_buf, and set properties
  set cpuclk_buf [ create_bd_cell -type ip -vlnv xilinx.com:ip:util_ds_buf:2.1 cpuclk_buf ]
  set_property -dict [ list \
CONFIG.C_BUF_TYPE {BUFG} \
 ] $cpuclk_buf

  # Create instance: mb0_lmb
  create_hier_cell_mb0_lmb [current_bd_instance .] mb0_lmb

  # Create instance: mdm_0, and set properties
  set mdm_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:mdm:3.2 mdm_0 ]

  # Create instance: microblaze_0, and set properties
  set microblaze_0 [ create_bd_cell -type ip -vlnv xilinx.com:ip:microblaze:10.0 microblaze_0 ]
  set_property -dict [ list \
CONFIG.C_BASE_VECTORS {0xd0000000} \
CONFIG.C_D_AXI {1} \
CONFIG.C_FSL_LINKS {1} \
CONFIG.C_ICACHE_BASEADDR {0x0000000000000000} \
CONFIG.C_ICACHE_HIGHADDR {0x000000003FFFFFFF} \
CONFIG.C_I_AXI {1} \
CONFIG.C_USE_BARREL {1} \
CONFIG.C_USE_DIV {1} \
CONFIG.C_USE_EXTENDED_FSL_INSTR {1} \
CONFIG.C_USE_MSR_INSTR {1} \
CONFIG.G_USE_EXCEPTIONS {0} \
 ] $microblaze_0

  # Create instance: sorting_network_0, and set properties
  set sorting_network_0 [ create_bd_cell -type ip -vlnv COMPAS:COMPAS:sorting_network:1.0.0 sorting_network_0 ]
  set_property -dict [ list \
CONFIG.BUFD_ORDER {19} \
 ] $sorting_network_0

  # Create instance: sys_reset, and set properties
  set sys_reset [ create_bd_cell -type ip -vlnv xilinx.com:ip:proc_sys_reset:5.0 sys_reset ]

  # Create instance: sysclk_buf, and set properties
  set sysclk_buf [ create_bd_cell -type ip -vlnv xilinx.com:ip:util_ds_buf:2.1 sysclk_buf ]
  set_property -dict [ list \
CONFIG.C_BUF_TYPE {BUFG} \
 ] $sysclk_buf

  # Create instance: vector_cpurst_or, and set properties
  set vector_cpurst_or [ create_bd_cell -type ip -vlnv xilinx.com:ip:util_vector_logic:2.0 vector_cpurst_or ]
  set_property -dict [ list \
CONFIG.C_OPERATION {or} \
CONFIG.C_SIZE {1} \
CONFIG.LOGO_FILE {data/sym_orgate.png} \
 ] $vector_cpurst_or

  # Create interface connections
  connect_bd_intf_net -intf_net QEMUPCIeBridge_0_M_AXI [get_bd_intf_pins QEMUPCIeBridge_0/M_AXI] [get_bd_intf_pins axixbar_peripheral/S02_AXI]
  connect_bd_intf_net -intf_net axi_bram_ctrl_0_BRAM_PORTA [get_bd_intf_pins axi_bram_ctrl_0/BRAM_PORTA] [get_bd_intf_pins blk_mem_gen_0/BRAM_PORTA]
  connect_bd_intf_net -intf_net axi_crossbar_dma_mm2s_M00_AXI [get_bd_intf_pins axi_crossbar_dma_mm2s/M00_AXI] [get_bd_intf_pins axi_crossbar_pcie_s/S01_AXI]
  connect_bd_intf_net -intf_net axi_crossbar_dma_mm2s_M01_AXI [get_bd_intf_pins axi_crossbar_dma_mm2s/M01_AXI] [get_bd_intf_pins axi_interconnect_mem/S01_AXI]
  connect_bd_intf_net -intf_net axi_crossbar_dma_s2mm_M00_AXI [get_bd_intf_pins axi_crossbar_dma_s2mm/M00_AXI] [get_bd_intf_pins axi_crossbar_pcie_s/S02_AXI]
  connect_bd_intf_net -intf_net axi_crossbar_dma_s2mm_M01_AXI [get_bd_intf_pins axi_crossbar_dma_s2mm/M01_AXI] [get_bd_intf_pins axi_interconnect_mem/S02_AXI]
  connect_bd_intf_net -intf_net axi_crossbar_pcie_s_M00_AXI [get_bd_intf_pins QEMUPCIeBridge_0/S_AXI] [get_bd_intf_pins axi_crossbar_pcie_s/M00_AXI]
  connect_bd_intf_net -intf_net axi_dma_0_M_AXIS_MM2S [get_bd_intf_pins axi_dma_0/M_AXIS_MM2S] [get_bd_intf_pins sorting_network_0/S_AXIS]
  connect_bd_intf_net -intf_net axi_dma_0_M_AXI_MM2S [get_bd_intf_pins axi_crossbar_dma_mm2s/S00_AXI] [get_bd_intf_pins axi_dma_0/M_AXI_MM2S]
  connect_bd_intf_net -intf_net axi_dma_0_M_AXI_S2MM [get_bd_intf_pins axi_crossbar_dma_s2mm/S00_AXI] [get_bd_intf_pins axi_dma_0/M_AXI_S2MM]
  connect_bd_intf_net -intf_net axi_dwidth_converter_0_M_AXI [get_bd_intf_pins axi_crossbar_pcie_s/S00_AXI] [get_bd_intf_pins axi_dwidth_converter_0/M_AXI]
  connect_bd_intf_net -intf_net axi_interconnect_mem_M00_AXI [get_bd_intf_pins axi_bram_ctrl_0/S_AXI] [get_bd_intf_pins axi_interconnect_mem/M00_AXI]
  connect_bd_intf_net -intf_net axixbar_0_M01_AXI [get_bd_intf_pins axi_uartlite_0/S_AXI] [get_bd_intf_pins axixbar_peripheral/M01_AXI]
  connect_bd_intf_net -intf_net axixbar_0_M02_AXI [get_bd_intf_pins axi_dwidth_converter_0/S_AXI] [get_bd_intf_pins axixbar_peripheral/M02_AXI]
  connect_bd_intf_net -intf_net axixbar_0_M03_AXI [get_bd_intf_pins axi_dma_0/S_AXI_LITE] [get_bd_intf_pins axixbar_peripheral/M03_AXI]
  connect_bd_intf_net -intf_net axixbar_peripheral_M00_AXI [get_bd_intf_pins axi_interconnect_mem/S00_AXI] [get_bd_intf_pins axixbar_peripheral/M00_AXI]
  connect_bd_intf_net -intf_net axixbar_peripheral_M04_AXI [get_bd_intf_pins axixbar_peripheral/M04_AXI] [get_bd_intf_pins sorting_network_0/S_AXI]
  connect_bd_intf_net -intf_net axixbar_peripheral_M05_AXI [get_bd_intf_pins QEMUPCIeBridge_0/S_AXI_CTL] [get_bd_intf_pins axixbar_peripheral/M05_AXI]
  connect_bd_intf_net -intf_net mdm_0_MBDEBUG_0 [get_bd_intf_pins mdm_0/MBDEBUG_0] [get_bd_intf_pins microblaze_0/DEBUG]
  connect_bd_intf_net -intf_net microblaze_0_DLMB [get_bd_intf_pins mb0_lmb/dlmb] [get_bd_intf_pins microblaze_0/DLMB]
  connect_bd_intf_net -intf_net microblaze_0_ILMB [get_bd_intf_pins mb0_lmb/ilmb] [get_bd_intf_pins microblaze_0/ILMB]
  connect_bd_intf_net -intf_net microblaze_0_M_AXI_DP [get_bd_intf_pins axixbar_peripheral/S00_AXI] [get_bd_intf_pins microblaze_0/M_AXI_DP]
  connect_bd_intf_net -intf_net microblaze_0_M_AXI_IP [get_bd_intf_pins axixbar_peripheral/S01_AXI] [get_bd_intf_pins microblaze_0/M_AXI_IP]
  connect_bd_intf_net -intf_net sorting_network_0_M_AXIS [get_bd_intf_pins axi_dma_0/S_AXIS_S2MM] [get_bd_intf_pins sorting_network_0/M_AXIS]

  # Create port connections
  connect_bd_net -net FPGA_SYSCLK_N_1 [get_bd_ports FPGA_SYSCLK_N] [get_bd_pins clk_wiz_0/clk_in1_n]
  connect_bd_net -net FPGA_SYSCLK_P_1 [get_bd_ports FPGA_SYSCLK_P] [get_bd_pins clk_wiz_0/clk_in1_p]
  connect_bd_net -net PCIE_CLK_N_1 [get_bd_ports PCIE_CLK_N] [get_bd_pins buf_pcieaxi_refclk/IBUF_DS_N]
  connect_bd_net -net PCIE_CLK_P_1 [get_bd_ports PCIE_CLK_P] [get_bd_pins buf_pcieaxi_refclk/IBUF_DS_P]
  connect_bd_net -net PCIE_RX_N_1 [get_bd_ports PCIE_RX_N] [get_bd_pins QEMUPCIeBridge_0/pci_exp_rxn]
  connect_bd_net -net PCIE_RX_P_1 [get_bd_ports PCIE_RX_P] [get_bd_pins QEMUPCIeBridge_0/pci_exp_rxp]
  connect_bd_net -net PERSTN_1 [get_bd_ports PERSTN] [get_bd_pins QEMUPCIeBridge_0/i_sys_rst_n]
  connect_bd_net -net QEMUPCIeBridge_0_o_axi_aclk [get_bd_pins QEMUPCIeBridge_0/i_axi_ctl_aclk] [get_bd_pins QEMUPCIeBridge_0/o_axi_aclk] [get_bd_pins axi_crossbar_dma_mm2s/aclk] [get_bd_pins axi_crossbar_dma_s2mm/aclk] [get_bd_pins axi_crossbar_pcie_s/aclk] [get_bd_pins axi_dma_0/m_axi_mm2s_aclk] [get_bd_pins axi_dma_0/m_axi_s2mm_aclk] [get_bd_pins axi_dwidth_converter_0/s_axi_aclk] [get_bd_pins axi_interconnect_mem/S01_ACLK] [get_bd_pins axi_interconnect_mem/S02_ACLK] [get_bd_pins axixbar_peripheral/M02_ACLK] [get_bd_pins axixbar_peripheral/M04_ACLK] [get_bd_pins axixbar_peripheral/M05_ACLK] [get_bd_pins axixbar_peripheral/S02_ACLK] [get_bd_pins sorting_network_0/i_clk]
  connect_bd_net -net QEMUPCIeBridge_0_o_axi_aresetn1 [get_bd_pins QEMUPCIeBridge_0/o_axi_aresetn] [get_bd_pins axi_crossbar_dma_mm2s/aresetn] [get_bd_pins axi_crossbar_dma_s2mm/aresetn] [get_bd_pins axi_crossbar_pcie_s/aresetn] [get_bd_pins axi_dwidth_converter_0/s_axi_aresetn] [get_bd_pins axi_interconnect_mem/S01_ARESETN] [get_bd_pins axi_interconnect_mem/S02_ARESETN] [get_bd_pins axixbar_peripheral/M02_ARESETN] [get_bd_pins axixbar_peripheral/M04_ARESETN] [get_bd_pins axixbar_peripheral/M05_ARESETN] [get_bd_pins axixbar_peripheral/S02_ARESETN] [get_bd_pins sorting_network_0/i_rst_n]
  connect_bd_net -net QEMUPCIeBridge_0_pci_exp_txn [get_bd_ports PCIE_TX_N] [get_bd_pins QEMUPCIeBridge_0/pci_exp_txn]
  connect_bd_net -net QEMUPCIeBridge_0_pci_exp_txp [get_bd_ports PCIE_TX_P] [get_bd_pins QEMUPCIeBridge_0/pci_exp_txp]
  connect_bd_net -net RESET_1 [get_bd_ports RESET] [get_bd_pins clk_wiz_0/reset] [get_bd_pins sys_reset/ext_reset_in]
  connect_bd_net -net UART_TXD_IN_1 [get_bd_ports UART_TXD_IN] [get_bd_pins axi_uartlite_0/rx]
  connect_bd_net -net axi_uartlite_0_tx [get_bd_ports UART_RXD_OUT] [get_bd_pins axi_uartlite_0/tx]
  connect_bd_net -net buf_pcieaxi_refclk_IBUF_OUT [get_bd_pins QEMUPCIeBridge_0/i_refclk] [get_bd_pins buf_pcieaxi_refclk/IBUF_OUT]
  connect_bd_net -net clk_wiz_0_clk_out1 [get_bd_pins clk_wiz_0/clk_out1] [get_bd_pins cpuclk_buf/BUFG_I] [get_bd_pins sysclk_buf/BUFG_I]
  connect_bd_net -net clk_wiz_0_locked [get_bd_pins clk_wiz_0/locked] [get_bd_pins sys_reset/dcm_locked]
  connect_bd_net -net cpuclk_buf_BUFG_O [get_bd_pins axixbar_peripheral/S00_ACLK] [get_bd_pins axixbar_peripheral/S01_ACLK] [get_bd_pins cpuclk_buf/BUFG_O] [get_bd_pins mb0_lmb/clk] [get_bd_pins microblaze_0/Clk]
  connect_bd_net -net mdm_0_Debug_SYS_Rst [get_bd_pins mdm_0/Debug_SYS_Rst] [get_bd_pins vector_cpurst_or/Op1]
  connect_bd_net -net sys_reset_interconnect_aresetn [get_bd_pins axi_bram_ctrl_0/s_axi_aresetn] [get_bd_pins axi_dma_0/axi_resetn] [get_bd_pins axi_interconnect_mem/ARESETN] [get_bd_pins axi_interconnect_mem/M00_ARESETN] [get_bd_pins axi_interconnect_mem/S00_ARESETN] [get_bd_pins axi_interconnect_mem/S03_ARESETN] [get_bd_pins axi_interconnect_mem/S04_ARESETN] [get_bd_pins axi_uartlite_0/s_axi_aresetn] [get_bd_pins axixbar_peripheral/ARESETN] [get_bd_pins axixbar_peripheral/M00_ARESETN] [get_bd_pins axixbar_peripheral/M01_ARESETN] [get_bd_pins axixbar_peripheral/M03_ARESETN] [get_bd_pins axixbar_peripheral/S00_ARESETN] [get_bd_pins axixbar_peripheral/S01_ARESETN] [get_bd_pins sys_reset/interconnect_aresetn]
  connect_bd_net -net sys_reset_mb_reset [get_bd_pins sys_reset/mb_reset] [get_bd_pins vector_cpurst_or/Op2]
  connect_bd_net -net sysclk_buf_BUFG_O [get_bd_pins axi_bram_ctrl_0/s_axi_aclk] [get_bd_pins axi_dma_0/s_axi_lite_aclk] [get_bd_pins axi_interconnect_mem/ACLK] [get_bd_pins axi_interconnect_mem/M00_ACLK] [get_bd_pins axi_interconnect_mem/S00_ACLK] [get_bd_pins axi_interconnect_mem/S03_ACLK] [get_bd_pins axi_interconnect_mem/S04_ACLK] [get_bd_pins axi_uartlite_0/s_axi_aclk] [get_bd_pins axixbar_peripheral/ACLK] [get_bd_pins axixbar_peripheral/M00_ACLK] [get_bd_pins axixbar_peripheral/M01_ACLK] [get_bd_pins axixbar_peripheral/M03_ACLK] [get_bd_pins sys_reset/slowest_sync_clk] [get_bd_pins sysclk_buf/BUFG_O]
  connect_bd_net -net vector_cpurst_or_Res [get_bd_pins mb0_lmb/rst] [get_bd_pins microblaze_0/Reset] [get_bd_pins vector_cpurst_or/Res]

  # Create address segments
  create_bd_addr_seg -range 0x00010000 -offset 0xE0030000 [get_bd_addr_spaces QEMUPCIeBridge_0/M_AXI] [get_bd_addr_segs QEMUPCIeBridge_0/S_AXI_CTL/CTL0] SEG_QEMUPCIeBridge_0_CTL0
  create_bd_addr_seg -range 0x00080000 -offset 0xF0000000 [get_bd_addr_spaces QEMUPCIeBridge_0/M_AXI] [get_bd_addr_segs axi_bram_ctrl_0/S_AXI/Mem0] SEG_axi_bram_ctrl_0_Mem0
  create_bd_addr_seg -range 0x00010000 -offset 0xE0010000 [get_bd_addr_spaces QEMUPCIeBridge_0/M_AXI] [get_bd_addr_segs axi_dma_0/S_AXI_LITE/Reg] SEG_axi_dma_0_Reg
  create_bd_addr_seg -range 0x00010000 -offset 0xE0000000 [get_bd_addr_spaces QEMUPCIeBridge_0/M_AXI] [get_bd_addr_segs axi_uartlite_0/S_AXI/Reg] SEG_axi_uartlite_0_Reg
  create_bd_addr_seg -range 0x00010000 -offset 0xE0020000 [get_bd_addr_spaces QEMUPCIeBridge_0/M_AXI] [get_bd_addr_segs sorting_network_0/CTRL0/REG0] SEG_sorting_network_0_REG0
  create_bd_addr_seg -range 0x80000000 -offset 0x00000000 [get_bd_addr_spaces axi_dma_0/Data_MM2S] [get_bd_addr_segs QEMUPCIeBridge_0/S_AXI/BAR0] SEG_QEMUPCIeBridge_0_BAR0
  create_bd_addr_seg -range 0x80000000 -offset 0x00000000 [get_bd_addr_spaces axi_dma_0/Data_S2MM] [get_bd_addr_segs QEMUPCIeBridge_0/S_AXI/BAR0] SEG_QEMUPCIeBridge_0_BAR0
  create_bd_addr_seg -range 0x00080000 -offset 0xF0000000 [get_bd_addr_spaces axi_dma_0/Data_MM2S] [get_bd_addr_segs axi_bram_ctrl_0/S_AXI/Mem0] SEG_axi_bram_ctrl_0_Mem0
  create_bd_addr_seg -range 0x00080000 -offset 0xF0000000 [get_bd_addr_spaces axi_dma_0/Data_S2MM] [get_bd_addr_segs axi_bram_ctrl_0/S_AXI/Mem0] SEG_axi_bram_ctrl_0_Mem0
  create_bd_addr_seg -range 0x80000000 -offset 0x00000000 [get_bd_addr_spaces microblaze_0/Data] [get_bd_addr_segs QEMUPCIeBridge_0/S_AXI/BAR0] SEG_QEMUPCIeBridge_0_BAR0
  create_bd_addr_seg -range 0x00010000 -offset 0xE0030000 [get_bd_addr_spaces microblaze_0/Data] [get_bd_addr_segs QEMUPCIeBridge_0/S_AXI_CTL/CTL0] SEG_QEMUPCIeBridge_0_CTL0
  create_bd_addr_seg -range 0x00080000 -offset 0xF0000000 [get_bd_addr_spaces microblaze_0/Data] [get_bd_addr_segs axi_bram_ctrl_0/S_AXI/Mem0] SEG_axi_bram_ctrl_0_Mem0
  create_bd_addr_seg -range 0x00080000 -offset 0xF0000000 [get_bd_addr_spaces microblaze_0/Instruction] [get_bd_addr_segs axi_bram_ctrl_0/S_AXI/Mem0] SEG_axi_bram_ctrl_0_Mem0
  create_bd_addr_seg -range 0x00010000 -offset 0xE0010000 [get_bd_addr_spaces microblaze_0/Data] [get_bd_addr_segs axi_dma_0/S_AXI_LITE/Reg] SEG_axi_dma_0_Reg
  create_bd_addr_seg -range 0x00010000 -offset 0xE0000000 [get_bd_addr_spaces microblaze_0/Data] [get_bd_addr_segs axi_uartlite_0/S_AXI/Reg] SEG_axi_uartlite_0_Reg
  create_bd_addr_seg -range 0x00040000 -offset 0xD0000000 [get_bd_addr_spaces microblaze_0/Data] [get_bd_addr_segs mb0_lmb/mb0_dlmb_bram_ctrl/SLMB/Mem] SEG_mb0_dlmb_bram_ctrl_Mem
  create_bd_addr_seg -range 0x00040000 -offset 0xD0000000 [get_bd_addr_spaces microblaze_0/Instruction] [get_bd_addr_segs mb0_lmb/mb0_ilmb_bram_ctrl/SLMB/Mem] SEG_mb0_ilmb_bram_ctrl_Mem
  create_bd_addr_seg -range 0x00010000 -offset 0xE0020000 [get_bd_addr_spaces microblaze_0/Data] [get_bd_addr_segs sorting_network_0/CTRL0/REG0] SEG_sorting_network_0_REG0

  # Exclude Address Segments
  create_bd_addr_seg -range 0x80000000 -offset 0x00000000 [get_bd_addr_spaces QEMUPCIeBridge_0/M_AXI] [get_bd_addr_segs QEMUPCIeBridge_0/S_AXI/BAR0] SEG_QEMUPCIeBridge_0_BAR0
  exclude_bd_addr_seg [get_bd_addr_segs QEMUPCIeBridge_0/M_AXI/SEG_QEMUPCIeBridge_0_BAR0]

  create_bd_addr_seg -range 0x80000000 -offset 0x00000000 [get_bd_addr_spaces microblaze_0/Instruction] [get_bd_addr_segs QEMUPCIeBridge_0/S_AXI/BAR0] SEG_QEMUPCIeBridge_0_BAR0
  exclude_bd_addr_seg [get_bd_addr_segs microblaze_0/Instruction/SEG_QEMUPCIeBridge_0_BAR0]

  create_bd_addr_seg -range 0x00010000 -offset 0xE0030000 [get_bd_addr_spaces microblaze_0/Instruction] [get_bd_addr_segs QEMUPCIeBridge_0/S_AXI_CTL/CTL0] SEG_QEMUPCIeBridge_0_CTL0
  exclude_bd_addr_seg [get_bd_addr_segs microblaze_0/Instruction/SEG_QEMUPCIeBridge_0_CTL0]

  create_bd_addr_seg -range 0x00010000 -offset 0xE0010000 [get_bd_addr_spaces microblaze_0/Instruction] [get_bd_addr_segs axi_dma_0/S_AXI_LITE/Reg] SEG_axi_dma_0_Reg
  exclude_bd_addr_seg [get_bd_addr_segs microblaze_0/Instruction/SEG_axi_dma_0_Reg]

  create_bd_addr_seg -range 0x00010000 -offset 0xE0000000 [get_bd_addr_spaces microblaze_0/Instruction] [get_bd_addr_segs axi_uartlite_0/S_AXI/Reg] SEG_axi_uartlite_0_Reg
  exclude_bd_addr_seg [get_bd_addr_segs microblaze_0/Instruction/SEG_axi_uartlite_0_Reg]

  create_bd_addr_seg -range 0x00010000 -offset 0xE0020000 [get_bd_addr_spaces microblaze_0/Instruction] [get_bd_addr_segs sorting_network_0/CTRL0/REG0] SEG_sorting_network_0_REG0
  exclude_bd_addr_seg [get_bd_addr_segs microblaze_0/Instruction/SEG_sorting_network_0_REG0]



  # Restore current instance
  current_bd_instance $oldCurInst

  save_bd_design
}
# End of create_root_design()


##################################################################
# MAIN FLOW
##################################################################

create_root_design ""


